<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Business extends Model
{
    use HasFactory;

    protected $fillable = [
    'id', 
    'business_logo',
    'business_logo_url',
    'business_cover',
    'business_cover_url',
    'business_logo_base64_code',	
    'business_logo_file_name',								
    'name',								
    'about',								
    'contact_title',								
    'contact_first_name',								
    'contact_last_name',								
    'contact_designation',								
    'contact_phone',							
    'contact_ext',								
    'contact_mobile',
    'contact_email',							
    'address_1',								
    'address_2',
    'city',								
    'state',	
    'state1',								
    'postal_code',							
    'country_id', 								
    'office_hours',								
    'website',								
    'official_email',								
    'office_phone',
    'office_toll_free_phone',
    'office_fax_phone',
    'type_id',							
    'category_id',								
    'sub_category_id',								
    'additional_details',								
    'special_offfers_discounts_details',							
    'offer_id',								
    'status_id',								
    'user_id',								
    'created_by',					
    'updated_by',								
    'created_at',					
    'updated_at'
    ];

    protected $hidden = ['pivot'];

    //business has many attachments
    public function businessAttachments()
    {
        return $this->hasMany('App\Models\BusinessAttachment');
    }

    //business has many categories
    public function businessCategories()
    {
       return $this->belongsToMany('App\Models\Category');
    }

    //business has many categories
    public function businessSubCategories()
    {
        return $this->belongsToMany('App\Models\SubCategory');
    }

    //business has many office hours
    public function businessOfficeHours()
    {
        return $this->belongsToMany('App\Models\OfficeHour')->using('App\Models\BusinessOfficeHour')->withPivot('start_time', 'end_time','is_closed');
    }

    //business has many offers
    public function businessOffers()
    {
        return $this->belongsToMany('App\Models\Offer');
    }
}