<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::post('password/reset', 'App\Http\Controllers\Auth\ResetPasswordController@reset');
Route::post('register', 'App\Http\Controllers\Auth\RegisteredUserController@store');
Route::post('forgot-password', 'App\Http\Controllers\Auth\PasswordResetLinkController@store');
Route::post('reset-password', 'App\Http\Controllers\Auth\NewPasswordController@store');


Route::group(['middleware' => ['auth:api']], function() {

    Route::get('/profile/{id}', 'App\Http\Controllers\User\AccountController@getUserProfile');
    Route::post('/profile/update/{id}', 'App\Http\Controllers\User\AccountController@updateUserProfile');
    Route::delete('/profile/delete/{id}', 'App\Http\Controllers\User\AccountController@deleteUserProfile');
    Route::post('/profile/changepassword/{id}', 'App\Http\Controllers\User\AccountController@changePassword');

    Route::post('/business/save/{id}', 'App\Http\Controllers\BusinessController@saveBusiness');
    Route::get('/business/all/{page_no}/{id}', 'App\Http\Controllers\BusinessController@getBusinesses');
    Route::get('/business/{id}/{user_id}', 'App\Http\Controllers\BusinessController@getBusiness');
    Route::delete('/business/delete/{id}', 'App\Http\Controllers\BusinessController@deleteBusiness');
    Route::post('/business/category/save/{id}', 'App\Http\Controllers\BusinessController@saveBusinessCategory');
    Route::get('/business1/meta/{id}', 'App\Http\Controllers\BusinessController@getBusinessMeta');

    Route::get('/job/meta/{id}', 'App\Http\Controllers\JobController@getJobMeta');
    Route::post('/job/save/{id}', 'App\Http\Controllers\JobController@saveJob');

    Route::post('/job/application/save/{id}', 'App\Http\Controllers\JobController@saveJobAppliation');

    Route::get('/jobs/listing/{page_no}/{usrer_id}','App\Http\Controllers\JobController@getJobsListing');
    Route::delete('/jobs/delete/{id}', 'App\Http\Controllers\JobController@deleteJob');
    Route::get('/jobs/application/all/{job_id}/{user_id}', 'App\Http\Controllers\JobController@getJobApplications');
    Route::post('/jobs/application/changestatus/{user_id}', 'App\Http\Controllers\JobController@changeJobApplicationStatus');
    Route::get('/jobs/application/view/{application_id}/{user_id}', 'App\Http\Controllers\JobController@getJobApplication');
    Route::get('/jobs1/{id}/{user_id}', 'App\Http\Controllers\JobController@getJob');
});

Route::post('/business1/listings', 'App\Http\Controllers\BusinessController@getBusinessListings');
Route::get('/businessdetails/{id}/{user_id}', 'App\Http\Controllers\BusinessController@getBusinessDetails');
Route::post('/business1/contact', 'App\Http\Controllers\BusinessController@contactBusiness');
Route::post('/business2/review/save', 'App\Http\Controllers\BusinessController@saveBusinessReview');

Route::get('/jobs/{page_no}/{id}', 'App\Http\Controllers\JobController@getJobs');
// Route::get('/jobdetails/{id}/{user_id}','App\Http\Controllers\JobController@getJobDetails');
Route::get('/jobdetails/{id}/{user_id}', 'App\Http\Controllers\JobController@getJobDetails');

Route::get('/capture', 'App\Http\Controllers\PaymentController@approveOrder');