<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::post('password/reset', 'App\Http\Controllers\Auth\ResetPasswordController@reset');
Route::post('register', 'App\Http\Controllers\Auth\RegisteredUserController@store');
Route::post('forgot-password', 'App\Http\Controllers\Auth\PasswordResetLinkController@store');
Route::post('reset-password', 'App\Http\Controllers\Auth\NewPasswordController@store');
Route::get('profile/meta/{user_id}', 'App\Http\Controllers\User\AccountController@getProfileMeta');

Route::group(['middleware' => ['auth:api']], function() {

    Route::get('/profile/{id}', 'App\Http\Controllers\User\AccountController@getUserProfile');
    Route::post('/profile/update/{id}', 'App\Http\Controllers\User\AccountController@updateUserProfile');
    Route::delete('/profile/delete/{id}', 'App\Http\Controllers\User\AccountController@deleteUserProfile');
    Route::post('/profile/changepassword/{id}', 'App\Http\Controllers\User\AccountController@changePassword');
    Route::get('/profile/package/{id}', 'App\Http\Controllers\User\AccountController@getUserPackageDetails');

    Route::post('/business/save/{id}', 'App\Http\Controllers\BusinessController@saveBusiness');
    Route::get('/business/all/{page_no}/{id}', 'App\Http\Controllers\BusinessController@getBusinesses');
    Route::get('/business/{id}/{user_id}', 'App\Http\Controllers\BusinessController@getBusiness');
    Route::delete('/business/delete/{id}', 'App\Http\Controllers\BusinessController@deleteBusiness');
    Route::post('/business/category/save/{id}', 'App\Http\Controllers\BusinessController@saveBusinessCategory');
    Route::get('/business1/meta/{id}', 'App\Http\Controllers\BusinessController@getBusinessMeta');

    Route::get('/job/meta/{id}', 'App\Http\Controllers\JobController@getJobMeta');
    Route::post('/job/save/{id}', 'App\Http\Controllers\JobController@saveJob');

    Route::post('/job/application/save/{id}', 'App\Http\Controllers\JobController@saveJobAppliation');

    Route::get('/jobs/listing/{page_no}/{usrer_id}','App\Http\Controllers\JobController@getJobsListing');
    Route::delete('/jobs/delete/{id}', 'App\Http\Controllers\JobController@deleteJob');
    Route::get('/jobs/application/all/{job_id}/{user_id}', 'App\Http\Controllers\JobController@getJobApplications');
    Route::get('/jobs/user/application/all/{user_id}', 'App\Http\Controllers\JobController@getUserJobApplications');
    Route::post('/jobs/application/changestatus/{user_id}', 'App\Http\Controllers\JobController@changeJobApplicationStatus');
    Route::get('/jobs/application/view/{application_id}/{user_id}', 'App\Http\Controllers\JobController@getJobApplication');
    Route::get('/jobs1/{id}/{user_id}', 'App\Http\Controllers\JobController@getJob');

    Route::get('/pricing/token/{user_id}', 'App\Http\Controllers\PaymentController@generateClientToken');
    Route::post('/pricing/packages/save/{id}', 'App\Http\Controllers\PaymentController@savePackage');

    Route::get('/inventory/{inventory_id}/items', 'App\Http\Controllers\InventoryController@getInventoryItems');
    Route::get('/inventory/item/single/{inventory_item_id}/{user_id}', 'App\Http\Controllers\InventoryController@getSingleInventoryItems');
    Route::get('/inventory/meta/{user_id}', 'App\Http\Controllers\InventoryController@getInventoryMeta');
    Route::get('/inventory/item/meta/{inventory_id}/{user_id}', 'App\Http\Controllers\InventoryController@getInventoryItemMeta');
    Route::post('/inventory/save/{user_id}', 'App\Http\Controllers\InventoryController@saveInventory');
    Route::get('/inventory/list/{user_id}', 'App\Http\Controllers\InventoryController@getInventoryList');
    Route::get('/inventory/single/{id}/{user_id}', 'App\Http\Controllers\InventoryController@getSingleInventory');
    Route::delete('/inventory/delete/{id}/{user_id}', 'App\Http\Controllers\InventoryController@deleteInventory');
    Route::post('/inventory/item/save/{user_id}', 'App\Http\Controllers\InventoryController@saveInventoryItem');

    Route::get('/jobs/apply/{user_id}', 'App\Http\Controllers\JobController@getApplyJobMeta');
});

Route::get('/pricing/packages', 'App\Http\Controllers\PaymentController@getPackages');
Route::post('/business1/listings', 'App\Http\Controllers\BusinessController@getBusinessListings');
Route::get('/businessdetails/{id}/{latitude}/{longitude}/{user_id}', 'App\Http\Controllers\BusinessController@getBusinessDetails');
Route::post('/business1/contact', 'App\Http\Controllers\BusinessController@contactBusiness');
Route::post('/business2/review/save', 'App\Http\Controllers\BusinessController@saveBusinessReview');

Route::post('/pricing/packages/save', 'App\Http\Controllers\PaymentController@savePackage');

Route::post('/jobs/{id}', 'App\Http\Controllers\JobController@getJobs');
// Route::get('/jobdetails/{id}/{user_id}','App\Http\Controllers\JobController@getJobDetails');
Route::get('/jobdetails/{id}/{user_id}', 'App\Http\Controllers\JobController@getJobDetails');

Route::get('/capture', 'App\Http\Controllers\PaymentController@approveOrder');


Route::get('/inventory/listings/{latitude}/{longitude}', 'App\Http\Controllers\InventoryController@getPublicInventoryListing');
Route::get('/inventory/items/{inventory_id}/{latitude}/{longitude}', 'App\Http\Controllers\InventoryController@getPublicInventoryItems');

Route::get('/inventory/items/details/{inventory_item_id}/{latitude}/{longitude}', 'App\Http\Controllers\InventoryController@getPublicInventoryItemDetails');

Route::get('/home/page/{latitude}/{longitude}', 'App\Http\Controllers\BusinessController@getHomePageData');