<?php

namespace App\Http\Controllers;

use App\Models\Business;
use App\Models\BusinessAttachment;
use App\Models\BusinessCategory;
use App\Models\BusinessLocation;
use App\Models\BusinessReview;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Notifications;
use App\Notifications\BusinessContact;
use App\Notifications\BusinessContactBack;
use Illuminate\Notifications\Notification;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Notification as FacadesNotification;
use Illuminate\Support\Facades\Storage;
use League\Flysystem\Config;
use PDO;
use stdClass;

class BusinessController extends Controller
{
    //
    public function saveBusiness(Request $request,$id)
    {
        $business_logo_base64_code = $request->input('business_logo_base64_code');	

        $business_cover_base64_code = $request->input('business_cover_base64_code');
        
        $business_logo_file_name = $request->input('business_logo_file_name');	

        if($request->input('id') != null)
        {
            $business = Business::find($request->input('id'));
        }
        else
        {
            $business = new Business();
        }

        $business->business_logo =  $request->input('business_logo');
        $business->status_id  =  $request->input('status_id');
        $business->name = $request->input('name');								
        $business->about = $request->input('about');								
        $business->contact_title = $request->input('contact_title');								
        $business->contact_first_name = $request->input('contact_first_name');								
        $business->contact_last_name = $request->input('contact_last_name');								
        $business->contact_designation = $request->input('contact_designation');								
        $business->contact_phone = $request->input('contact_phone');							
        $business->contact_ext = $request->input('contact_ext');								
        $business->contact_mobile = $request->input('contact_mobile');
        $business->contact_email = $request->input('contact_email');							
        $business->address_1 = $request->input('address_1');								
        $business->address_2 = $request->input('address_2');
        $business->latitude = $request->input('latitude');
        $business->longitude = $request->input('longitude');
        $business->is_show_location = $request->input('is_show_location');
        $business->city = $request->input('city');
        $business->city1 = $request->input('city1');
        $business->state = $request->input('state');	
        $business->state1 = $request->input('state1');								
        $business->postal_code = $request->input('postal_code');							
        $business->country = $request->input('country');
        $business->office_hours = $request->input('office_hours');								
        $business->website = $request->input('website');	
        
        $business->office_twitter = $request->input('office_twitter');	
        $business->office_facebook = $request->input('office_facebook');	
        $business->office_linkedin = $request->input('office_linkedin');
        $business->office_instagram = $request->input('office_instagram');
        
        $business->official_email = $request->input('official_email');								
        $business->office_phone = $request->input('office_phone');
        $business->office_toll_free_phone = $request->input('office_toll_free_phone');
        $business->office_fax_phone = $request->input('office_fax_phone');							
        $business->type_id = $request->input('type_id');							
        $business->additional_details = $request->input('additional_details');								
        $business->special_offfers_discounts_details = $request->input('special_offfers_discounts_details');							
        $business->offer_id = $request->input('offer_id');								
        $business->status_id = $request->input('status_id');								
        $business->user_id = $id;
        $business->created_by = $id;

        $business->save();

        $business_categories_array = $request->input('business_categories');
        $business_sub_categories_array = $request->input('business_sub_categories');
        $business_office_hours_array = $request->input('business_office_hours');
        $business_offers_array = $request->input('business_offers');

        $business->businessCategories()->detach();
        if(sizeof($business_categories_array) > 0)
        {
            $business_categories = array();
            foreach($business_categories_array as $bca)
            {
                $category = new \stdClass();
                $category->category_id = $bca['category_id'];

                $business_categories [] = (array)$category;
            }
            $business->businessCategories()->attach($business_categories);
        }

        $business->businessSubCategories()->detach();
        if(sizeof($business_sub_categories_array) > 0)
        {
            $business_sub_categories = array();
            foreach($business_sub_categories_array as $bsca)
            {
                $sub_category = new \stdClass();
                $sub_category->sub_category_id = $bsca['sub_category_id'];

                $business_sub_categories [] = (array)$sub_category;
            }
            $business->businessSubCategories()->attach($business_sub_categories);
        }

        $business->businessOffers()->detach();
        if(sizeof($business_offers_array) > 0)
        {
            $business_offers = array();
            foreach($business_offers_array as $bo)
            {
                $offer = new \stdClass();
                $offer->offer_id = $bo['offer_id'];

                $business_offers [] = (array)$offer;
            }
            $business->businessOffers()->attach($business_offers);
        }

        $business->businessOfficeHours()->detach();
        if(sizeof($business_office_hours_array) > 0)
        {
            $business_office_hours = array();
            foreach($business_office_hours_array as $boh)
            {
                $hour = new \stdClass();

                $hour->office_hour_id = $boh['office_hour_id'];
                $hour->start_time = isset($boh['start_time']) ? $boh['start_time'] : null;
                $hour->end_time = isset($boh['end_time']) ? $boh['end_time'] : null;
                $hour->is_closed = $boh['is_closed'];

                $business_office_hours [] = (array)$hour;
            }
            $business->businessOfficeHours()->attach($business_office_hours);
        }

        $business_folder_path = $business->id.'_'.str_replace('-','_',str_replace(' ','_',$business->name)).'/';
        
        $folder_path =  'public/uploads/businessattachments/' . $business_folder_path ;

        if($business_logo_base64_code != null)
    {

        if($request->input('id') != null)
        {
            Storage::disk('local')->delete('public/'.$business->business_logo_url);
        }

        preg_match("/data:image\/(.*?);/", $business_logo_base64_code, $file_extension);
        @list($type, $file_data) = explode(';', $business_logo_base64_code);
        @list(, $file_data) = explode(',', $file_data);


        $fileName = 'file_' . time() . '_' . rand(pow(10, 3 - 1), pow(10, 3) - 1) . '.' . $file_extension[1];

        Storage::disk('local')->put($folder_path.'logo/'. $fileName, base64_decode($file_data));

        $business->business_logo_url ='uploads/businessattachments/' .$business_folder_path. 'logo/'.$fileName;

        $business->save();
    }

        if($business_cover_base64_code != null)
        {

            if($request->input('id') != null)
            {
                Storage::disk('local')->delete('public/'.$business->business_cover_url);
            }

            preg_match("/data:image\/(.*?);/", $business_cover_base64_code, $file_extension);
            @list($type, $file_data) = explode(';', $business_cover_base64_code);
            @list(, $file_data) = explode(',', $file_data);
            
    
            $fileName = 'file_' . time() . '_' . rand(pow(10, 3 - 1), pow(10, 3) - 1) . '.' . $file_extension[1];
    
            Storage::disk('local')->put($folder_path.'cover/'. $fileName, base64_decode($file_data));
    
            $business->business_cover_url = 'uploads/businessattachments/' .$business_folder_path. 'cover/'.$fileName;
    
            $business->save();
        }

        $business_attachments = $request->input('business_attachments');

        if (sizeof($business_attachments) > 0) {
                foreach ($business_attachments as $d) {

                    if($d['is_deleted'] == 1)
                    {
                        Storage::disk('local')->delete('public/'.$d['encrypted_name']);

                        $attachment = BusinessAttachment::find($d['id']);
                        $attachment->delete();
                    }
                    else
                    {
                        if($d['is_new'] == 1)
                        {
                            preg_match("/data:image\/(.*?);/", $d['base64_code'], $file_extension) ||
                            preg_match("/data:text\/(.*?);/", $d['base64_code'], $file_extension) ||
                            preg_match("/data:application\/(.*?);/", $d['base64_code'], $file_extension) ||
                            preg_match("/data:video\/(.*?);/", $d['base64_code'], $file_extension);
                            @list($type, $file_data) = explode(';', $d['base64_code']);
                            @list(, $file_data) = explode(',', $file_data);



                            $fileName = 'file_' . time() . '_' . rand(pow(10, 3 - 1), pow(10, 3) - 1) . '.' . $file_extension[1];

                            $folder_path =  'public/uploads/businessattachments/' . $business_folder_path .'attachments/';



                            Storage::disk('local')->put($folder_path . $fileName, base64_decode($file_data));

                            $fileName = 'uploads/businessattachments/' .$business_folder_path. 'attachments/'.$fileName;


                            $attachment = new BusinessAttachment();
                            $attachment->original_name = $d['original_name'];
                            $attachment->encrypted_name = $fileName;
                            $attachment->ext = $d['ext'];
                            $attachment->mime_type = $d['mime_type'];
                            $attachment->size = $d['size'];
                            $attachment->attachment_type_id = $d['attachment_type_id'];
                            $attachment->attachment_category_id = $d['attachment_category_id'];
                            $attachment->business_id = $business->id;
                            $attachment->created_by = $id;

                            $attachment->save();
                        }

                     }

                                    }
                                }

        $business_locations = $request->input('business_locations');

        if (sizeof($business_locations) > 0) {
            foreach ($business_locations as $l) {


                if(isset($l['id']))
                {
                    $loc = BusinessLocation::find($l['id']);
                    $loc->updated_by = $id;
                }
                else
                {
                    $loc = new BusinessLocation();
                    $loc->created_by = $id;
                }

                $business_location_cover_base64_code = isset($l['business_location_cover_base64_code']) ? $l['business_location_cover_base64_code'] : null;



                $loc->address_1 = isset($l['address_1']) ? $l['address_1'] : null ;
                $loc->address_2 = isset($l['address_2']) ? $l['address_2'] : null ;
                $loc->state = isset($l['state']) ? $l['state'] : null ;
                $loc->state1 = isset($l['state1']) ? $l['state1'] : null ;
                $loc->country = isset($l['country']) ? $l['country'] : null ;
                $loc->city = isset($l['city']) ? $l['city'] : null ;
                $loc->city1 = isset($l['city1']) ? $l['city1'] : null;
                $loc->postal_code = isset($l['postal_code']) ? $l['postal_code'] : null ;
                $loc->phone = isset($l['phone']) ? $l['phone'] : null ;
                $loc->email = isset($l['email']) ? $l['email'] : null ;

                $loc->after_office_phone = isset($l['after_office_phone']) ? $l['after_office_phone'] : null ;
                $loc->toll_free_phone = isset($l['toll_free_phone']) ? $l['toll_free_phone'] : null ;

                $loc->title = isset($l['title']) ? $l['title'] : null ;
                $loc->description = isset($l['description']) ? $l['description'] : null ;
                $loc->business_location_cover = isset($l['business_location_cover']) ? $l['business_location_cover'] : null ;

                $loc->latitude = isset($l['latitude']) ? $l['latitude'] : null ;
                $loc->longitude = isset($l['longitude']) ? $l['longitude'] : null ;
                $loc->is_show_location = isset($l['is_show_location']) ? $l['is_show_location'] : null ;


                $business->businessLocations()->save($loc);

                if($business_location_cover_base64_code != null)
                {

                    $folder_path =  'public/uploads/businessattachments/' . $business_folder_path ;

                    if(isset($l['id']) && $l['id'] != null)
                    {
                        Storage::disk('local')->delete('public/'.$loc->business_location_cover_url);
                    }

                    preg_match("/data:image\/(.*?);/", $business_location_cover_base64_code, $file_extension);
                    @list($type, $file_data) = explode(';', $business_location_cover_base64_code);
                    @list(, $file_data) = explode(',', $file_data);


                    $fileName = 'file_' . time() . '_' . rand(pow(10, 3 - 1), pow(10, 3) - 1) . '.' . $file_extension[1];

                    Storage::disk('local')->put($folder_path.'cover/'. $fileName, base64_decode($file_data));

                    $loc->business_location_cover_url = 'uploads/businessattachments/' .$business_folder_path. 'cover/'.$fileName;

                    $loc->save();
                }


                $business_location_sub_categories_array = isset($l['business_location_sub_categories']) ? $l['business_location_sub_categories'] : [] ;
                $business_location_office_hours_array = isset($l['business_location_office_hours']) ? $l['business_location_office_hours'] : [] ;
                $business_location_amenities_array = isset($l['business_location_amenities']) ? $l['business_location_amenities'] : [];

                $loc->businessLocationSubCategories()->detach();
                if(sizeof($business_location_sub_categories_array) > 0)
                {
                    $business_location_sub_categories = array();
                    foreach($business_location_sub_categories_array as $bsca)
                    {
                        $sub_category = new \stdClass();
                        $sub_category->sub_category_id = $bsca['sub_category_id'];

                        $business_location_sub_categories [] = (array)$sub_category;
                    }
                    $loc->businessLocationSubCategories()->attach($business_location_sub_categories);
                }

                $loc->businessLocationAmenities()->detach();
                if(sizeof($business_location_amenities_array) > 0)
                {
                    $business_location_amenities = array();
                    foreach($business_location_amenities_array as $bsca)
                    {
                        $amenity = new \stdClass();
                        $amenity->amenity_id = $bsca['amenity_id'];

                        $business_location_amenities [] = (array)$amenity;
                    }
                    $loc->businessLocationAmenities()->attach($business_location_amenities);
                }

                $business_location_office_hours_array = array_filter($business_location_office_hours_array,function ($item){
                    return $item['is_checked'] == true;
                });


//                return response()->json(['items' => $business_location_office_hours_array],500);

                $loc->businessLocationOfficeHours()->detach();
                if(sizeof($business_location_office_hours_array) > 0)
                {
                    $business_location_office_hours = array();
                    foreach($business_location_office_hours_array as $boh)
                    {
                        $hour = new \stdClass();

                        $hour->office_hour_id = $boh['office_hour_id'];
                        $hour->start_time = isset($boh['start_time']) ? $boh['start_time'] : null;
                        $hour->end_time = isset($boh['end_time']) ? $boh['end_time'] : null;
                        $hour->business_location_office_hour_type = isset($boh['business_location_office_hour_type']) ? $boh['business_location_office_hour_type'] : null;
                        $hour->is_closed = $boh['is_closed'];

                        $business_location_office_hours [] = (array)$hour;
                    }
                    $loc->businessLocationOfficeHours()->attach($business_location_office_hours);
                }


//                $locations_array [] = (array) $loc;
            }

//            $locations_array = collect()
//
//            $business->businessLocations()->saveMany($locations_array);
        }


        return response()->json(['success' => 'saved'],200);
            
    }

    public function getBusinesses($page_no,$id)
    {

        $pdo = DB::connection()->getPdo();

        $pdo->setAttribute(PDO::ATTR_EMULATE_PREPARES, true);


        $stmt = $pdo->prepare('CALL get_businesses(:puserid,:page_no)');

        $stmt->execute(array('puserid' => $id,'page_no' => $page_no));

        $business_count = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');
        $business_count = $business_count != null ? $business_count[0]->business_count : 0;

        $stmt->nextRowset();

        $businesses = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');


        return response()->json([
            'businesses' => $businesses,
            'business_count' => $business_count 
        ],200,[], JSON_NUMERIC_CHECK) ;
    }

    public function deleteBusiness($id)
    {
        $business = Business::find($id);

        $business_folder_path = $business->id.'_'.str_replace('-','_',str_replace(' ','_',$business->name)).'/';

        $business->businessAttachments()->delete();

        $business->businessCategories()->detach();

        $business->businessSubCategories()->detach();
        
        Storage::disk('local')->delete('public/uploads/businessattachments/'.$business_folder_path);

        $business->delete();
    }

    public function getBusiness($id,$user_id)
    {
        $business = Business::find($id);
        $business_attachments = $business->businessAttachments()->get();
        $business_locations = $business->businessLocations()->get();
        $business_categories = $business->businessCategories()->select('id as category_id','name')->get();
        $business_sub_categories = $business->businessSubCategories()->select('id as sub_category_id','name')->get();
        $business_office_hours = $business->businessOfficeHours()->get();
        $business_offers = $business->businessOffers()->select('id as offer_id','name')->get();

        $business_office_hours_array = array();
        foreach($business_office_hours as $boh)
        {
            $hour = new \stdClass();
            $hour->office_hour_id = $boh->pivot->office_hour_id;
            $hour->start_time = $boh->pivot->start_time;
            $hour->end_time = $boh->pivot->end_time;
            $hour->is_closed = $boh->pivot->is_closed;

            $business_office_hours_array [] = (array) $hour; 
        }




        $pdo = DB::connection()->getPdo();

        $pdo->setAttribute(PDO::ATTR_EMULATE_PREPARES, true);

        $user = User::find($user_id);

        if($user->role_id == 1)
        {
            $stmt = $pdo->prepare('CALL get_admin_business_categories()');
        }
        else
        {
            $stmt = $pdo->prepare('CALL get_business_categories(?)');
        }

        $stmt->execute(array($id));

        $categories = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $sub_categories = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $office_hours = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $offers = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $cities = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $states = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $amenities = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $office_hours_array = array();

        $pdo = null;

        $stmt = null;

        foreach($office_hours as $oh)
        {
            $hour = new \stdClass();
            $hour = $oh ;

            $business_hour = collect($business_office_hours_array)->where('office_hour_id',$hour->office_hour_id)->first();

            if($business_hour != null)
            {
                $hour->is_checked = true;
                $hour->start_time = $business_hour['start_time'];
                $hour->end_time = $business_hour['end_time'];
                $hour->is_closed = $business_hour['is_closed'];
            }
            else
            {
                $hour->is_checked = false;
            }

            $office_hours_array [] = (array) $hour;
        }

        $business_locations_array = array();

        foreach ($business_locations as $bl)
        {
            $loc = new stdClass();

            $loc->id = $bl->id;
            $loc->address_1 = $bl->address_1;
            $loc->address_2 = $bl->address_2;
            $loc->state = $bl->state;
            $loc->state1 = $bl->state1;
            $loc->city = $bl->city;
            $loc->city1 = $bl->city1;
            $loc->postal_code = $bl->postal_code;
            $loc->phone = $bl->phone;
            $loc->email = $bl->email;
            $loc->title = $bl->title;
            $loc->description = $bl->description;
            $loc->business_location_cover = $bl->business_location_cover;
            $loc->business_location_cover_url = $bl->business_location_cover_url;
            $loc->after_office_phone = $bl->after_office_phone;
            $loc->toll_free_phone = $bl->toll_free_phone;
            $loc->is_show_location = $bl->is_show_location;
            $loc->latitude = $bl->latitude;
            $loc->longitude = $bl->longitude;

            $loc->business_location_sub_categories = $bl->businessLocationSubCategories()->select('id as sub_category_id','name')->get();
            $loc->business_location_amenities = $bl->businessLocationAmenities()->select('id as amenity_id','name')->get();


            $location_office_hours = $bl->businessLocationOfficeHours()->get();



            $loc->business_location_office_hours_array  = array();

            foreach($location_office_hours as $loh)
            {



                $hour = new \stdClass();

                $hour->office_hour_id = (int) $loh->pivot->office_hour_id;
                $hour->start_time = $loh->pivot->start_time;
                $hour->end_time = $loh->pivot->end_time;
                $hour->is_closed = (int) $loh->pivot->is_closed;
                $hour->business_location_office_hour_type = (int) $loh->pivot->business_location_office_hour_type;

                $loc->business_location_office_hours_array [] = (array) $hour;
//
//                if($loc->id == 23 && $hour->office_hour_id == 5)
//                {
//                    return response()->json(['loc' =>  $loc->business_location_office_hours_array,'loh' => $hour],500);
//                }
            }

            $loc->business_location_office_hours = array();

            for($i=1;$i<=3;$i++)
            {
                foreach($office_hours as $oh)
                {
                    $hour = new \stdClass();
                    $hour->office_hour_id = $oh->office_hour_id;
                    $hour->name = $oh->name;


                    $business_hour = collect($loc->business_location_office_hours_array)
                        ->where('office_hour_id',$oh->office_hour_id)
                        ->where('business_location_office_hour_type',$i)->first();

                    if($business_hour != null)
                    {
                        $hour->is_checked = true;
                        $hour->start_time = $business_hour['start_time'];
                        $hour->end_time = $business_hour['end_time'];
                        $hour->is_closed = $business_hour['is_closed'];
                        $hour->business_location_office_hour_type = $business_hour['business_location_office_hour_type'];

                    }
                    else
                    {
                        $hour->is_checked = false;
                        $hour->start_time = null;
                        $hour->end_time = null;
                        $hour->is_closed = null;
                        $hour->business_location_office_hour_type = $i;
                    }

                    $loc->business_location_office_hours []  = (array) $hour;
                }
            }
            $business_locations_array [] = (array) $loc;
        }


        return response()->json([
            'business' => $business, 
            'business_attachments' => $business_attachments,
            'business_locations' => $business_locations_array,
            'business_categories' => $business_categories,
            'business_sub_categories' => $business_sub_categories,
            'business_office_hours' => $office_hours_array,
            'business_offers' =>  $business_offers,
            'categories' => $categories,
            'sub_categories' => $sub_categories,
            'offers' => $offers,
            'cities' => $cities,
            'states' => $states,
            'amenities' => $amenities
        ],200,[], JSON_NUMERIC_CHECK);
    }

    public function getBusinessDetails($id,$latitude,$longitude,$user_id)
    {
        $current_time = $this->getCreatedAtAttribute(Carbon::now());

        $current_day = $current_time->formatLocalized('%A');

        $pdo = DB::connection()->getPdo();

        $latitude = $latitude == 'undefined' ? null : $latitude;
        $longitude = $longitude == 'undefined' ? null : $longitude;

        $pdo->setAttribute(PDO::ATTR_EMULATE_PREPARES, true);

        $stmt = $pdo->prepare('CALL get_business_details(?,?,?)');

        $stmt->execute(array($id,$latitude,$longitude));
        
        $business = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');
        $business = $business[0];
        $stmt->nextRowset();

        $business_attachments = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $business_office_hours = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $business_offers = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $business_reviews = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $related_businesses = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $related_business_office_hours = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $related_business_attachments = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $business_locations = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $business_location_office_hours = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $business_location_sub_categories = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $business_location_amenities = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $inventories = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $business_obj = new stdClass();

        $business_obj = $business;

        $business_obj->inventories = $inventories;

        $business_obj->business_attachments = $business_attachments;
        $business_obj->business_office_hours = $business_office_hours;

        $business_obj->business_offers = $business_offers;
        $business_obj->business_reviews = $business_reviews;
//        $business_obj->business_locations = $business_locations;
        $business_obj->selected_img = sizeof($business_obj->business_attachments) > 0 ? $business_obj->business_attachments[0] : null;

        $current_office_hour = collect($business_obj->business_office_hours)->where('name',$current_day)->where('is_closed',0)->first();

        $business_obj->closed_in = $current_office_hour == null || ($current_office_hour != null && !$current_time->betweenExcluded(Carbon::parse($current_office_hour->start_time),Carbon::parse($current_office_hour->end_time)) && $current_office_hour->start_time != $current_office_hour->end_time) ? 'Closed' : 'Closes '  .date("g:i a", strtotime($current_office_hour->end_time));

        $next_office_hour = $business_obj->closed_in == 'Closed' ?  ($current_office_hour != null && $current_time->lt(Carbon::parse($current_office_hour->start_time)) ? $current_office_hour :  collect($business_obj->business_office_hours)->where('office_hour_id', '>',$current_time->dayOfWeek)->where('is_closed',0)->first()) : null;

        $business_obj->opens_in =  $next_office_hour != null ? 'Opens '.date("g:i A", strtotime($next_office_hour->start_time)).' '.$next_office_hour->name : null;


        foreach ($business_obj->business_office_hours as $boh)
        {
            $boh->start_time =    date("g:i A", strtotime($boh->start_time));
            $boh->end_time =    date("g:i A", strtotime($boh->end_time));
        }


        $related_businesses_array = array();
        foreach($related_businesses as $b)
        {
            $bus = new stdClass();
            $bus = $b;

            $bus->selected_img = collect($related_business_attachments )->where('business_id',$bus->id)->first();
         
            $bus->business_office_hours = array_values(collect($related_business_office_hours)->where('business_id',$bus->id)->toArray());

            $current_office_hour = collect($bus->business_office_hours)->where('name',$current_day)->where('is_closed',0)->first();

            // return response()->json(['test' =>Carbon::now(config('app.timezone', 'UTC'))],500);

            $bus->closed_in = $current_office_hour == null || ($current_office_hour != null && !$current_time->betweenExcluded(Carbon::parse($current_office_hour->start_time),Carbon::parse($current_office_hour->end_time)) && $current_office_hour->start_time != $current_office_hour->end_time) ? 'Closed' : 'Closes '  .date("g:i a", strtotime($current_office_hour->end_time));

            $next_office_hour = $bus->closed_in == 'Closed' ?  ($current_office_hour != null && $current_time->lt(Carbon::parse($current_office_hour->start_time)) ? $current_office_hour :  collect($bus->business_office_hours)->where('office_hour_id', '>',$current_time->dayOfWeek)->where('is_closed',0)->first()) : null;

            $bus->opens_in =  $next_office_hour != null ? 'Opens '.date("g:i A", strtotime($next_office_hour->start_time)).' '.$next_office_hour->name : null;

            foreach ($bus->business_office_hours as $boh)
            {
                $boh->start_time =    date("g:i A", strtotime($boh->start_time));
                $boh->end_time =    date("g:i A", strtotime($boh->end_time));
            }

            $related_businesses_array [] = (array) $bus;
        }

        $business_obj->related_businesses = $related_businesses_array;

        $business_location_array = array();
        foreach ($business_locations as $bl)
        {
            $location = new stdClass();
            $location = $bl;
            $location->is_show_location = (boolean)$bl->is_show_location;

            $location->business_location_office_hours = array_values(collect($business_location_office_hours)->where('business_location_id',$location->id)->toArray());
            $location->business_location_sub_categories = array_values(collect($business_location_sub_categories)->where('business_location_id',$location->id)->toArray());
            $location->business_location_amenities = array_values(collect($business_location_amenities)->where('business_location_id',$location->id)->toArray());


            foreach ($location->business_location_office_hours as $boh)
            {
                $boh->start_time =    date("g:i A", strtotime($boh->start_time));
                $boh->end_time =    date("g:i A", strtotime($boh->end_time));
            }

            $business_location_array [] = (array) $location;
        }

        $business_obj->business_locations = $business_location_array;

        return response()->json([
            'business' => $business_obj,
    ],200,[], JSON_NUMERIC_CHECK);
    

    }

    public function saveBusinessCategory(Request $request,$id)
    {
        $category = new BusinessCategory();
        $category->name = $request->input('name');
        $category->created_by = $id;

        $category->save();

        return response()->json(['id' => $category->id],200,[], JSON_NUMERIC_CHECK);
    }

    public function getBusinessMeta($id)
    {
        $user = User::find($id);

        $pdo = DB::connection()->getPdo();

        $pdo->setAttribute(PDO::ATTR_EMULATE_PREPARES, true);

        if($user->role_id == 1)
        {
            $stmt = $pdo->prepare('CALL get_admin_business_categories()');
        }
        else
        {
            $stmt = $pdo->prepare('CALL get_business_categories(?)');
        }

        $stmt->execute(array($id));

        $categories = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $sub_categories = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $office_hours = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $offers = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $cities = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $states = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $amenities = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');


        return response()->json([
            'categories' => $categories,
            'sub_categories' => $sub_categories,
            'office_hours' => $office_hours,
            'offers' => $offers,
            'cities' => $cities,
            'states' => $states,
            'amenities' => $amenities
        ],200,[], JSON_NUMERIC_CHECK);
    }

    public function getBusinessListings(Request $request)
    {

        $current_time = $this->getCreatedAtAttribute(Carbon::now());

//        return response()->json(['time' => $current_time],500);

        $search_query = $request->input('search_query');

        $category_ids_array = $request->input('categories_array');

        $sub_category_ids_array = $request->input('sub_categories_array');

        $states_array = $request->input('states_array');

        $cities_array = $request->input('cities_array');

        $category_ids = sizeof($category_ids_array) > 0 ? implode(',',$category_ids_array) : null;

        $sub_category_ids = sizeof($sub_category_ids_array) > 0 ? implode(',',$sub_category_ids_array) : null;

        $latitude = $request->input('latitude');

        $longitude = $request->input('longitude');

        $is_filter_applied = $search_query != null || $category_ids != null || $sub_category_ids != null ? 1 : 0;

        $is_location_accessible = $latitude != null && $longitude != null ? 1 : 0;

        $page_no = $request->input('page_no');

        $is_open = $request->input('is_open');

        $states = sizeof($states_array) > 0 ? implode(',',$states_array) : null;

        $cities = sizeof($cities_array) > 0 ? implode(',',$cities_array) : null;

        $current_day = $current_time->formatLocalized('%A');

        $pdo = DB::connection()->getPdo();

        $pdo->setAttribute(PDO::ATTR_EMULATE_PREPARES, true);

        $stmt = $pdo->prepare('CALL get_business_listings_2(?,?,?,?,?,?,?,?,?,?)');

        $stmt->execute(array($search_query,$page_no,$category_ids,$sub_category_ids,$latitude,$longitude,$is_filter_applied,$is_location_accessible,$states,$cities));

        $business_attachments = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $business_office_hours = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        // return response()->json(['sample' => $business_office_hours],500);

        $stmt->nextRowset();

        $business_count = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');
        $business_count = $business_count != null ? $business_count[0]->business_count : 0;

        $stmt->nextRowset();

        $businesses = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

//        return response()->json(['is_filter_applied' => $is_filter_applied,'is_location_accessible' => $is_location_accessible,'businesses' => $businesses],500);


        $is_category_request = $request->input('is_category_request');

        if($is_category_request == true)
        {
            $pdo = DB::connection()->getPdo();

            $pdo->setAttribute(PDO::ATTR_EMULATE_PREPARES, true);

            $stmt = $pdo->prepare('CALL get_business_listing_categories_1()');

            $stmt->execute();

            $categories = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

            $stmt->nextRowset();

            $sub_categories = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

            $stmt->nextRowset();

            $states = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

            $stmt->nextRowset();

            $cities = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');


            $categories_array = array();
            foreach($categories as $ct)
            {
                $cat = new stdClass();
                $cat = $ct;

                $cat->sub_categories = array_values(collect($sub_categories)->where('category_id',$ct->category_id)->toArray());

                $categories_array [] = (array) $cat;
            }
        }
        else
        {
            $categories_array = array();

            $cities =[];
            $states = [];
        }

        $businesses_array = array();
        foreach($businesses as $b)
        {
            $bus = new stdClass();
            $bus = $b;
            $bus->is_show_location = (boolean) $b->is_show_location;
            $bus->is_read_more = false;
            $bus->about_count = strlen($bus->about);

            $bus->business_attachments = array_values(collect($business_attachments)->where('business_id',$bus->id)->toArray());

            $bus->business_office_hours = array_values(collect($business_office_hours)->where('business_id',$bus->id)->toArray());

            $bus->selected_img = sizeof($bus->business_attachments) > 0 ? $bus->business_attachments[0] : null;

            $current_office_hour = collect($bus->business_office_hours)->where('name',$current_day)->where('is_closed',0)->first();

            // return response()->json(['test' =>Carbon::now(config('app.timezone', 'UTC'))],500);

            $bus->closed_in = $current_office_hour == null || ($current_office_hour != null && !$current_time->betweenExcluded(Carbon::parse($current_office_hour->start_time),Carbon::parse($current_office_hour->end_time)) && $current_office_hour->start_time != $current_office_hour->end_time) ? 'Closed' : 'Closes '  .date("g:i A", strtotime($current_office_hour->end_time));

            $next_office_hour = $bus->closed_in == 'Closed' ?  ($current_office_hour != null && $current_time->lt(Carbon::parse($current_office_hour->start_time)) ? $current_office_hour :  collect($bus->business_office_hours)->where('office_hour_id', '>',$current_time->dayOfWeek)->where('is_closed',0)->first()) : null;

            $bus->opens_in =  $next_office_hour != null ? 'Opens '.date("g:i A", strtotime($next_office_hour->start_time)).' '.$next_office_hour->name : null;

            if ($is_open == false || ($is_open == true && $bus->closed_in != 'Closed'))
            {
                $businesses_array [] = (array) $bus;
            }

            foreach ($bus->business_office_hours as $boh)
            {
                $boh->start_time =    date("g:i A", strtotime($boh->start_time));
                $boh->end_time =    date("g:i A", strtotime($boh->end_time));
            }
        }



        $business_count = sizeof($businesses_array) == 0 ? 0 :  $business_count;

        return response()->json([
            'businesses' => $businesses_array,
            'categories' => $categories_array,
            'business_count' => $business_count,
            'timeNow' => $this->getCreatedAtAttribute(Carbon::now()),
            'timezone' =>  config('app.timezone', 'UTC'),
            'states' => $states,
            'cities' => $cities
    ],200,[], JSON_NUMERIC_CHECK);
    }

    public function getCreatedAtAttribute($value)
    {
        $timezone = config('app.timezone', 'UTC');
        return Carbon::parse($value)->setTimezone($timezone);  //remove this one if u want to return Carbon object
    }

    public function contactBusiness(Request $request)
    {  
        $business = Business::find($request->input('business_id'));

        $first_name = $request->input('first_name');
        $last_name = $request->input('last_name');
        $email = $request->input('email');
        $phone_number = $request->input('phone_number');
        $message = $request->input('message');

        $message = $request->input('message');
        $message = $request->input('message');

        $is_contact_by_mail = $request->input('is_contact_by_mail');
        $is_contact_by_phone = $request->input('is_contact_by_phone');

        $via_contact = '';

        if($is_contact_by_mail == true && $is_contact_by_phone == true)
        {
            $contact = 'email and phonenumber';
            $via_contact = 'Contact By '.$contact.' is available';
        }
        else if($is_contact_by_mail == true && $is_contact_by_phone != true)
        {
            $contact = 'email';
            $via_contact = 'Contact By '.$contact.' is available';
        }
        else if($is_contact_by_mail != true && $is_contact_by_phone == true)
        {
            $contact = 'phonenumber';
            $via_contact = 'Contact By '.$contact.' is available';
        }

        $business_id = $request->input('business_id');

        $business = Business::find($business_id);


        try
        {
            FacadesNotification::route('mail', $business->contact_email)->notify(new BusinessContact($first_name,$last_name,$email,$phone_number,$message,$via_contact,$business->name));
        }
        catch (\Exception $e)
        {

        }

        try
        {
            FacadesNotification::route('mail',$email)->notify(new BusinessContactBack($first_name,$last_name,$business->name));
        }
        catch (\Exception $e)
        {
//            return response()->json(['error',$e],500);
        }

        return response()->json(['success' => 'saved'],200);

    }

    public function saveBusinessReview(Request $request)
    {
        $review = new BusinessReview();
        
        $review->user_id = $request->input('user_id');
        $review->ip_address = $request->ip();
        $review->feedback = $request->input('feedback');
        $review->rating = $request->input('rating');
        $review->business_id = $request->input('business_id');

        $review->save();

        return response()->json(['sucess' => 'saved'],200);

    }

    public function getHomePageData($latitude,$longitude)
    {
        $current_time = $this->getCreatedAtAttribute(Carbon::now());
        $current_day = $current_time->formatLocalized('%A');

        $pdo = DB::connection()->getPdo();

        $latitude = $latitude == 'undefined' ? null : $latitude;
        $longitude = $longitude == 'undefined' ? null : $longitude;

        $pdo->setAttribute(PDO::ATTR_EMULATE_PREPARES, true);

        $stmt = $pdo->prepare('CALL get_home_page_data_2(?,?)');

        $stmt->execute(array($latitude, $longitude));

        $business_office_hours = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $businesses = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $inventories = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $jobs = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $inventory_filter = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $business_filter = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $job_filter = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $brands = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $business_logos = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');


        $businesses_array = array();
        foreach($businesses as $b)
        {
            $bus = new stdClass();
            $bus = $b;
            $bus->is_show_location = (boolean) $b->is_show_location;
            $bus->is_read_more = false;

            $bus->business_office_hours = array_values(collect($business_office_hours)->where('business_id',$bus->id)->toArray());

            $current_office_hour = collect($bus->business_office_hours)->where('name',$current_day)->where('is_closed',0)->first();

            // return response()->json(['test' =>Carbon::now(config('app.timezone', 'UTC'))],500);

            $bus->closed_in = $current_office_hour == null || ($current_office_hour != null && !$current_time->betweenExcluded(Carbon::parse($current_office_hour->start_time),Carbon::parse($current_office_hour->end_time)) && $current_office_hour->start_time != $current_office_hour->end_time) ? 'Closed' : 'Closes '  .date("g:i A", strtotime($current_office_hour->end_time));

            $next_office_hour = $bus->closed_in == 'Closed' ?  ($current_office_hour != null && $current_time->lt(Carbon::parse($current_office_hour->start_time)) ? $current_office_hour :  collect($bus->business_office_hours)->where('office_hour_id', '>',$current_time->dayOfWeek)->where('is_closed',0)->first()) : null;

            $bus->opens_in =  $next_office_hour != null ? 'Opens '.date("g:i A", strtotime($next_office_hour->start_time)).' '.$next_office_hour->name : null;

            $businesses_array [] = (array) $bus;

        }

        $jobs_array = array();

        foreach ($jobs as $j)
        {

            $jb = new stdClass();

            $jb = $j;

            $jb->is_show_location = (boolean)$jb->is_show_location;

            $jb->tags = explode(',', $jb->job_tags);

            $jb->benefits = explode(',', $jb->job_benefits);

            $jobs_array [] = (array) $jb;

        }

        return response()->json(['businesses' => $businesses,
            'inventories' =>$inventories,
            'jobs' => $jobs_array,
            'inventory_filter' => $inventory_filter,
            'business_filter' => $business_filter,
            'job_filter'=> $job_filter,
            'brands' => $brands,
            'business_logos' => $business_logos],200);
    }

}


