<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Business extends Model
{
    use HasFactory;

    protected $fillable = [
    ];

    protected $hidden = ['pivot'];

    //business has many attachments
    public function businessAttachments()
    {
        return $this->hasMany('App\Models\BusinessAttachment');
    }

    //business has many attachments
    public function businessLocations()
    {
        return $this->hasMany('App\Models\BusinessLocation');
    }

    //business has many categories
    public function businessCategories()
    {
       return $this->belongsToMany('App\Models\Category');
    }

    //business has many categories
    public function businessSubCategories()
    {
        return $this->belongsToMany('App\Models\SubCategory');
    }

    //business has many office hours
    public function businessOfficeHours()
    {
        return $this->belongsToMany('App\Models\OfficeHour')
            ->using('App\Models\BusinessOfficeHour')
            ->withPivot('start_time', 'end_time','is_closed');
    }

    //business has many offers
    public function businessOffers()
    {
        return $this->belongsToMany('App\Models\Offer');
    }
}