<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Illuminate\Support\HtmlString;

class BusinessContact extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */

    public $first_name;
    public $last_name;
    public $email;
    public $phone_number;
    public $message;
    public $via_contact;
    public $business_name;

    public function __construct($first_name,$last_name,$email,$phone_number,$message,$via_contact,$business_name)
    {
        $this->first_name = $first_name;
        $this->last_name = $last_name;
        $this->email = $email;
        $this->phone_number = $phone_number;
        $this->message = $message;
        $this->via_contact = $via_contact;
        $this->business_name = $business_name;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
            -> from('info@thetruckingnetwork.ca','Business Contact')
            ->greeting('Hi '.$this->business_name)
            ->line('You have  new inquiry from your business listing')
            ->line('')
            ->line('First Name: '.$this->first_name)
            ->line('Last Name: '.$this->last_name)
            ->line('Email: '.$this->email)
            ->line('Phone Number: '.$this->phone_number)
            ->line('Message: '.$this->message)
            ->line($this->via_contact);
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
