<?php

namespace App\Notifications;

use Hamcrest\Core\HasToString;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Illuminate\Support\HtmlString;

class NewJobApplication extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */

    public $personal_name;
    public $personal_email;
    public $personal_mobile_number;
    public $job_id;
    public $job_title;
    public $posted_by_name;

    public function __construct($personal_name,$personal_email,$personal_mobile_number,$job_id,$job_title,$posted_by_name)
    {
        //
        $this->personal_name = $personal_name;
        $this->personal_email = $personal_email;
        $this->personal_mobile_number = $personal_mobile_number;
        $this->job_id = $job_id;
        $this->job_title = $job_title;
        $this->posted_by_name = $posted_by_name;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
                    ->from('info@thetruckingnetwork.ca','New Job Application')
                    ->greeting('Hi '.$this->posted_by_name)
                    ->line(New HtmlString('You have a new applicant for your  <strong>'.$this->job_title.'</strong>'))
                    ->line('Please login to BusinessPage360 admin dashboard to view the details.')
                    ->line('We highly appreciate your business!')
                    ->line(New HtmlString('<strong>Applicant Information</strong>'))
                    ->line(new HtmlString('Name: <strong>'.$this->personal_name.'</strong>'))
                    ->line(New HtmlString('Email: <strong>'.$this->personal_email.'</strong>'))
                    ->line(New HtmlString('Mobile Number: <strong>'.$this->personal_mobile_number.'</strong>'))
                    ->action('View Job', url(config('APP_URL').'jobs/details/'.$this->job_id));
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
