<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class NotifyFleetAdmin extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public $phone;
    public $email;
    public $payment_method;
    public $first_name;
    public $last_name;
    public $company_name;
    public $designation;
    public $comments;
    public $registarion_id;
    public $attendees_number;

    public function __construct($email,$phone,$payment_method,$first_name,$last_name,$company_name,$designation,$comments,$attendees_number,$registarion_id)
    {
        //
        $this->phone = $phone;
        $this->email = $email;
        $this->payment_method = $payment_method;
        $this->registarion_id = $registarion_id;

        $this->first_name = $first_name;
        $this->last_name = $last_name;
        $this->company_name = $company_name;
        $this->designation = $designation;

        $this->comments = $comments;

        $this->attendees_number = $attendees_number;

    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->from('info@thetruckingnetwork.ca',  'Fleet Executive Summit 2024')
            ->cc('nav@thetruckingnetwork.ca')
            ->subject('New Registration IN Fleet Executive Summit')
            ->view('emails.fleet-email',['name'=> 'Admin',
                'banner' =>   'fes-bannner-2.png',
                'content' => 'There is a new registration in Fleet Executive Summit Toronto 2024. November 27, 2024',
                'fleet_url' =>  'https://fleetexecsummit.net/ticket/'.$this->registarion_id,
                'first_name' =>  $this->first_name,
                'last_name' =>  $this->last_name,
                'company_name' =>  $this->company_name,
                'designation' =>  $this->designation,
                'comments' =>  $this->comments,
                'email' =>  $this->email,
                'phone' =>  $this->phone,
                'payment_method' => $this->payment_method,
                'attendees_number' => $this->attendees_number,
                'type' => 'admin'
            ]);
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
