<?php
/**
 * Created by PhpStorm.
 * User: Omen
 * Date: 2/7/2024
 * Time: 12:17 AM
 */

namespace App\Notifications;


use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class NotifyGreenAdmin extends Notification
{
        use Queueable;

        /**
         * Create a new notification instance.
         *
         * @return void
         */
        public $phone;
        public $email;
        public $payment_method;
        public $first_name;
        public $last_name;
        public $company_name;
        public $designation;
        public $comments;
        public $registarion_id;

        public function __construct($email,$phone,$payment_method,$first_name,$last_name,$company_name,$designation,$comments,$registarion_id)
        {
            //
            $this->phone = $phone;
            $this->email = $email;
            $this->payment_method = $payment_method;
            $this->registarion_id = $registarion_id;

            $this->first_name = $first_name;
            $this->last_name = $last_name;
            $this->company_name = $company_name;
            $this->designation = $designation;

            $this->comments = $comments;

        }

        /**
         * Get the notification's delivery channels.
         *
         * @param  mixed  $notifiable
         * @return array
         */
        public function via($notifiable)
        {
            return ['mail'];
        }

        /**
         * Get the mail representation of the notification.
         *
         * @param  mixed  $notifiable
         * @return \Illuminate\Notifications\Messages\MailMessage
         */
        public function toMail($notifiable)
        {
            return (new MailMessage)
                ->from('waqaramjad04@gmail.com',  'Green Freight Summit 2024')
                ->cc('waqaramjad04@gmail.com')
                ->subject('New Registration IN Green Freight Summit')
                ->view('emails.green-email',['name'=> 'Admin',
                    'banner' =>   'fes-bannner-2.png',
                    'content' => 'There is a new registration in Green Freight Summit Toronto 2024.',
                    'fleet_url' =>  'https://greenfreightinnovation.ca/ticket/'.$this->registarion_id,
                    'first_name' =>  $this->first_name,
                    'last_name' =>  $this->last_name,
                    'company_name' =>  $this->company_name,
                    'designation' =>  $this->designation,
                    'comments' =>  $this->comments,
                    'email' =>  $this->email,
                    'phone' =>  $this->phone,
                    'payment_method' => $this->payment_method,
                    'type' => 'admin'
                ]);
        }

        /**
         * Get the array representation of the notification.
         *
         * @param  mixed  $notifiable
         * @return array
         */
        public function toArray($notifiable)
        {
            return [
                //
            ];
        }
}